<?php
// Variáveis para armazenar os resultados da consulta
$mac_address = ''; 
$payment_link = null; 

if (isset($_POST["mac_address"])) {
    // Pega o valor digitado e converte para maiúsculas
    $mac_address = strtoupper(trim($_POST["mac_address"]));

    // Conectar ao banco de dados de links de pagamento
    $db3 = new SQLite3('./api/.payment_links.db');

    if ($db3) {
        // Consulta ao banco de dados de links de pagamento, usando LIKE para permitir a busca pelos últimos 4 caracteres
        $stmt_payment = $db3->prepare("SELECT payment_link FROM payment_links WHERE UPPER(mac_address) LIKE :mac_address");

        // Verifica se a consulta foi preparada corretamente
        if ($stmt_payment) {
            // Define o valor para a consulta com curinga '%' antes dos 4 caracteres finais
            $stmt_payment->bindValue(':mac_address', '%' . substr($mac_address, -4), SQLITE3_TEXT);
            $payment_link = $stmt_payment->execute()->fetchArray(SQLITE3_ASSOC);
        } else {
            echo "<p>Erro ao preparar a consulta para links de pagamento: " . $db3->lastErrorMsg() . "</p>";
        }
    } else {
        echo "<p>Erro ao conectar ao banco de dados de links de pagamento.</p>";
    }
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Renovação IPTV</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #000;
            background-image: url('fd.png');
            background-size: cover;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }
        .search-container {
            background-color: #fff;
            padding: 40px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            text-align: center;
            width: 100%;
            max-width: 500px;
        }
        .search-container h1 {
            font-size: 24px;
            margin-bottom: 20px;
        }
        .search-container input {
            margin-bottom: 20px;
        }
        .search-container button {
            background-color: #007bff;
            color: #fff;
        }
        .search-container img {
            margin-bottom: 15px;
        }
        .search-container p {
            color: #007bff;
            font-size: 14px;
        }
    </style>
</head>
<body>

<div class="search-container">
     <h1>Olá, para Renovação da sua Lista</h1>
    <img src="https://ibo5max.cssatnet.top/ibo5/qrpixok.png" alt="CssatNet" width="100" height="100">
    <p>QR Code PIX - Banco Inter!</p>
<body>

<div class="search-container">
    <h1>Entrar em contato via Whats</h1>
    <img src="https://ibo5max.cssatnet.top/ibo5/qr.png" alt="CssatNet" width="100" height="100">
    <p>Scaneia o QR Code acima para contato ou suporte</p>
</div>

</body>
</html>