<?php
// Caminho do arquivo contendo o link do vídeo
$arquivo = './splashscreen/splashscreen.txt';

// Verifica se o arquivo existe
if (file_exists($arquivo)) {
    // Lê o conteúdo do arquivo (link do vídeo)
    $link = trim(file_get_contents($arquivo));

    // Verifica se o link é válido
    if (!empty($link) && filter_var($link, FILTER_VALIDATE_URL)) {
        // Redireciona para o link do vídeo
        header("Location: $link");
        exit;
    } else {
        echo "O link no arquivo não é válido.";
    }
} else {
    echo "Arquivo não encontrado.";
}
?>
