<?php
ini_set('display_errors', 1);
if(session_status() === PHP_SESSION_NONE) session_start();
include(__DIR__ . '/functions.php');
$adTypeJsonPath = __DIR__ . '/ad_type.json';
$adb = new SQLite3('./api/.adb.db');
$adb3 = new SQLite3('./api/.db_logo.db');
$adb4 = new SQLite3('./api/.db_bg.db'); 
$adTypeData = json_decode(file_get_contents($adTypeJsonPath), true);
$currentAdType = $adTypeData['adType'] ?? 'manual';

if ($currentAdType === 'tmdb') {
    $adsPageUrl = "tmdb_api.php";
} else {
    $adsPageUrl = "ads.php";
}

if (!isset($_SESSION['name'])) {
    header("Location: index.php");
    exit;
}

$log_check = $db->select('users', '*', 'id = :id', '', [':id' => 1]);
$loggedinuser = !empty($log_check) ? $log_check[0]['username'] : null;

if ($_SESSION['name'] !== $loggedinuser) {
    header("Location: index.php");
    exit;
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="author" content="Painel IBO">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/css/bootstrap.min.css" integrity="sha384-MCw98/SFnGE8fJT3GXwEOngsV7Zt27NXFoaoApmYm81iuXoPkFOJwJ8ERdknLPMO" crossorigin="anonymous">
    <link href="css/themes/darkly/bootstrap.css" rel="stylesheet" title="main">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/3.2.3/animate.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link href="css/simple-sidebar.css" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
    

</head>
<body>
<style>
body{
  background-color: #2d283d;
  background-image: url("");
  color: #fff;
}

#particles-js{
  background-size: cover;
  background-position: 50% 50%;
  background-repeat: no-repeat;
  background: #8000FF;
  display: flex;
  justify-content: center;
  align-items: center;
}

.particles-js-canvas-el{
  position: fixed;
}

#pageMessages {
  left: 50%;
  transform: translateX(-50%);
  position: fixed; 
  text-align: center;
  top: 5px;
  width: 60%;
  z-index: 9999; 
  border-radius: 0px;
}

.alert {
  position: relative;
}

.alert .close {
  position: absolute;
  top: 5px;
  right: 5px;
  font-size: 1em;
}

.alert .fa {
  margin-right: .3em;
}

.modal-dialog {
    display: flex;
    align-items: center;
    min-height: calc(100% - 1rem);
}
</style>
<div id="js-particles"></div>

<div class="d-flex" id="wrapper">
    <!-- Sidebar -->
    <div id="sidebar-wrapper">
        <div class="sidebar-heading">Ibo Max 5.0 </div>
        <span>
            <a class="list-group-item" href="https://wa.me/5513996434617" target="_blank">&nbsp;&nbsp;&nbsp;&nbsp;&#169; <?=date("Y")?> + Scripts Apks </a>
        </span>
        <div class="list-group list-group-flush">
            <a class="list-group-item list-group-item-action" href="dns.php">
                <i class="fa fa-cogs"></i>&nbsp;&nbsp;DNS Servidor
            </a>
            <a class="list-group-item list-group-item-action" href="playlists.php">
                <i class="fa fa-user"></i>&nbsp;&nbsp;Usuários
            </a>
            <!--<a class="list-group-item list-group-item-action" href="nomeapk.php">
                <i class="fa fa-rss"></i>&nbsp;&nbsp;Texto Tela de Login
            </a>-->
         


           <a class="list-group-item list-group-item-action" href="#" data-toggle="modal" data-target="#customizeModal">
    <i class="fa fa-cogs"></i>&nbsp;&nbsp;Personalizar&nbsp;&nbsp;
    <i class="fa fa-chevron-down" style="margin-left: 1px;"></i>
</a>

            <a class="list-group-item list-group-item-action" href="qrcode.php">
                <i class="fa fa-qrcode"></i>&nbsp;&nbsp;Qrcode
            </a>


            <a class="list-group-item list-group-item-action" href="renovar.php" target="_blank">
                <i class="fa fa-credit-card-alt"></i>&nbsp;&nbsp;Renovação Automatica
            </a>
            

            
            <a class="list-group-item list-group-item-action" href="user.php">
                <i class="fa fa-lock"></i>&nbsp;&nbsp;ADMIN
            </a>
           </div>
           </div>
    <!-- /#sidebar-wrapper -->
    <div class="modal fade" id="customizeModal" tabindex="-1" role="dialog" aria-labelledby="customizeModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="customizeModalLabel">Personalizar</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                
=
                
                              <a class="dropdown-item" href="icones.php">
                <i class="fa fa-tachometer"></i>&nbsp;&nbsp;Icons TV FILMES SERIES
            </a>
                
                <a class="dropdown-item" href="bg.php">
                    <i class="fa fa-image"></i>&nbsp;&nbsp;Mudar Fundo
                </a>
                <a class="dropdown-item" href="logo.php">
                    <i class="fa fa-image"></i>&nbsp;&nbsp;Mudar Logo
                </a>

              <a class="dropdown-item" href="settings.php">
                <i class="fa fa-rss"></i>&nbsp;&nbsp;Texto App
            </a>
                        <a class="dropdown-item" href="mRTXAdsSetting.php">
                <i class="fa fa-exchange"></i>&nbsp;&nbsp;Banner Man/Auto
            </a>
            
             <a class="dropdown-item" href="ads.php">
                <i class="fa fa-cloud-upload"></i>&nbsp;&nbsp;Banners Manual
            </a> 
            </div>
        </div>
    </div>
</div>

<script>

let mensagem_filmes = "";
let mensgem_canais = "";
let mensagem_series = "";

// Realizar a requisição
axios.get("../processar_permissoes_buscar_mensagens.php")
    .then(response => {
        if (response.data.status === 'sucesso') {
            const mensagens = response.data.mensagens;

            // Verificar se os elementos existem antes de definir os valores
            console.log('Mensagem Filmes:', mensagens.mensagem_filmes);
            const inputFilmes = document.getElementById('mensagemFilmes');
            mensagem_filmes = mensagens.mensagem_filmes;
            if (inputFilmes) {
                inputFilmes.value = mensagens.mensagem_filmes;
            }

            console.log('Mensagem Séries:', mensagens.mensagem_series);
            const inputSeries = document.getElementById('mensagemSeries');
            mensagem_series = mensagens.mensagem_series;
            if (inputSeries) {
                inputSeries.value = mensagens.mensagem_series;
            }

            console.log('Mensagem Canais:', mensagens.mensagem_canais);
            const inputCanais = document.getElementById('mensagemCanais');
            mensagem_canais = mensagens.mensagem_canais;
            if (inputCanais) {
                inputCanais.value = mensagens.mensagem_canais;
            }
        } else {
            console.error('Erro:', response.data.mensagem);
        }
    })
    .catch(error => {
        console.error('Erro na requisição:', error);
    });

    

    // Função para exibir o input correspondente
function mostrarInput(tipo) {
    // Esconde todos os inputs
    document.querySelectorAll('.inputMensagem').forEach(input => {
        input.style.display = 'none';
    });

    // Exibe o input correspondente ao tipo selecionado
    if (tipo === 'Filmes') {
        document.getElementById('inputFilmes').style.display = 'block';
        document.getElementById('mensagemFilmes').value = mensagem_filmes;
    } else if (tipo === 'Canais') {
        document.getElementById('inputCanais').style.display = 'block';
        document.getElementById('mensagemCanais').value = mensagem_canais;
        
    } else if (tipo === 'Séries') {
        document.getElementById('inputSeries').style.display = 'block';
        document.getElementById('mensagemSeries').value = mensagem_series;
    }
}

// Função para enviar a mensagem
function enviarMensagem() {
    let mensagem = '';
    let tipoMensagem = '';

    // Verifica qual input está visível e pega a mensagem correspondente
    if (document.getElementById('inputFilmes').style.display === 'block') {
        mensagem = document.getElementById('mensagemFilmes').value;
        tipoMensagem = 'Filmes';
        mensagem_filmes = mensagem;
    } else if (document.getElementById('inputCanais').style.display === 'block') {
        mensagem = document.getElementById('mensagemCanais').value;
        tipoMensagem = 'Canais';
        mensagem_canais = mensagem;
    } else if (document.getElementById('inputSeries').style.display === 'block') {
        mensagem = document.getElementById('mensagemSeries').value;
        tipoMensagem = 'Séries';
         mensagem_series = mensagem;
    }

    // Se a mensagem estiver vazia, mostra um alerta
    if (!mensagem) {
        alert('Por favor, insira uma mensagem.');
        return;
    }

    // Envia a requisição para atualizar a mensagem na DB
    axios.post('processar_permissoes_mensagem.php', {
        tipo_mensagem: tipoMensagem,
        mensagem: mensagem
    })
    .then(function(response) {
        console.log(response.data);
        alert('Mensagem enviada com sucesso!');
        $('#permissoesModal').modal('hide'); // Fecha o modal após o envio
    })
    .catch(function(error) {
        console.error(error);
        alert('Erro ao enviar mensagem');
    });
}
    
</script>

<!-- Modal para editar permissões/mensagens -->
<div class="modal fade" id="permissoesMensagemModal" tabindex="-1" role="dialog" aria-labelledby="permissoesMensagemModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="permissoesModalLabel">Editar Mensagem das Permissões</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <!-- Botões para escolher entre Filmes, Canais e Séries -->
                <p>Selecione para qual deseja editar a mensagem que aparecerá quando o usuario não tiver a permissão adequada: </p>
                <div>
                    <button id="btnFilmes" class="btn btn-info" onclick="mostrarInput('Filmes')">Filmes</button>
                    <button id="btnCanais" class="btn btn-info" onclick="mostrarInput('Canais')">Canais</button>
                    <button id="btnSeries" class="btn btn-info" onclick="mostrarInput('Séries')">Séries</button>
                </div>
                <br>

                <!-- Inputs para cada tipo de mensagem -->
                <div id="inputFilmes" class="inputMensagem" style="display: none;">
                    <label for="mensagemFilmes">Mensagem de Filmes:</label>
                    <input type="text" id="mensagemFilmes" class="form-control" placeholder="Digite a mensagem para Filmes">
                </div>
                <div id="inputCanais" class="inputMensagem" style="display: none;">
                    <label for="mensagemCanais">Mensagem de Canais:</label>
                    <input type="text" id="mensagemCanais" class="form-control" placeholder="Digite a mensagem para Canais">
                </div>
                <div id="inputSeries" class="inputMensagem" style="display: none;">
                    <label for="mensagemSeries">Mensagem de Séries:</label>
                    <input type="text" id="mensagemSeries" class="form-control" placeholder="Digite a mensagem para Séries">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                <button type="button" class="btn btn-primary" onclick="enviarMensagem()">Enviar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="permissoesModal" tabindex="-1" role="dialog" aria-labelledby="permissoesModal" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="customizeModalLabel">Permissões desse usuário:</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p id="modalID"></p> <!-- Aqui será exibido o ID passado -->
                
                <!-- Checkboxes -->
                <div class="form-check">
                    <input type="checkbox" class="form-check-input" id="filmesCheckbox">
                    <label class="form-check-label" for="filmesCheckbox">Filmes</label>
                </div>
                <div class="form-check">
                    <input type="checkbox" class="form-check-input" id="canaisCheckbox">
                    <label class="form-check-label" for="canaisCheckbox">Canais</label>
                </div>
                <div class="form-check">
                    <input type="checkbox" class="form-check-input" id="seriesCheckbox">
                    <label class="form-check-label" for="seriesCheckbox">Séries</label>
                </div>
                <br>
                
                <br>
                <!-- Botão Enviar -->
                <button type="button" class="btn btn-info" id="enviarPermissoes">Enviar</button>
            </div>
        </div>
    </div>
</div>


    <!-- Page Content -->
    <div id="page-content-wrapper">
        <nav class="navbar navbar-expand-lg navbar-dark">
            <button class="btn btn-primary" id="menu-toggle">
                <img src="img/logo.png" width="25" height="25" class="d-flex justify-content-center text-align centre" alt="">
            </button>
            &nbsp;&nbsp;
            <div class="center" id="pageMessages"></div>
            <a href="logout.php" class="btn btn-danger ml-auto mr-1">Logout</a>
        </nav>
        <div class="container-fluid"><br>