<?php 
ob_start(); // Inicia o buffer de saída
include './includes/header.php'; 

// Caminho do arquivo JSON
$jsonPath = 'img/api01.json';

// Verifica se o arquivo JSON existe
if (file_exists($jsonPath)) {
    $jsonData = file_get_contents($jsonPath);
    $dataArray = json_decode($jsonData, true);

    // Verifica se o JSON é válido
    if ($dataArray && isset($dataArray['data'][0])) {
        $data = &$dataArray['data'][0]; // Referência para modificar diretamente
        $name = $data['name'] ?? '';
    } else {
        echo "Erro: JSON inválido ou vazio.";
        exit;
    }
} else {
    echo "Erro: Arquivo JSON não encontrado.";
    exit;
}

// Verifica se o formulário foi enviado
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['name'])) {
    $newName = trim($_POST['name']);
    
    // Atualiza o nome no array
    $data['name'] = $newName;

    // Salva o JSON atualizado no arquivo
    file_put_contents($jsonPath, json_encode($dataArray, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));

    // Redireciona sem erro
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

ob_end_flush(); // Envia a saída do buffer
?>

<div class="card radius-10">
    <div class="card-body">
        <h4 class="card-title">Editar Nome</h4>
    
        <form class="forms-sample" method="post">
            <div class="form-group mb-4">
                <label class="control-label" for="name">
                    <strong>Nome:</strong>
                </label>
                <div class="input-group">
                    <input type="text" id="name" name="name" value="<?php echo htmlspecialchars($name); ?>" class="form-control" placeholder="Digite o nome" />
                </div>
            </div>
            <button type="submit" class="btn btn-primary mr-2">Salvar</button>
        </form>
    </div>
</div>

<?php include './includes/footer.php'; ?>
