<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Renovar Acesso</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        /* Adicionando estilos gerais */
        body {
            font-family: Arial, sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
            background: url('') no-repeat center center fixed; 
            background-size: cover;
            background-color: #2d283d;
        }

        .container {
            text-align: center;
            background-color: #ffffff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            width: 100%;
            max-width: 400px;
        }

        .logo img {
            width: 100px;
            height: 100px;
            object-fit: contain;
        }

        .message {
            margin-top: 10px;
            font-size: 16px;
            color: #333;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .message i {
            margin-right: 8px;
            color: #007bff;
        }

        .search-box {
            margin-top: 20px;
        }

        .search-box form {
            display: flex;
            flex-direction: column;
            align-items: center;
        }

        .search-box input[type="text"] {
            padding: 10px;
            font-size: 16px;
            border: 1px solid #ccc;
            border-radius: 4px;
            margin-bottom: 10px;
            width: 100%;
            max-width: 300px;
            padding-left: 35px;
            background: url('') no-repeat 10px center;
            background-size: 20px;
        }

        .search-box button {
            padding: 12px 24px;
            font-size: 18px;
            width: 100%;
            max-width: 200px;
            height: 40px;
            color: #fff;
            background-color: #007bff;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .search-box button i {
            margin-right: 8px;
        }

        .search-box button:hover {
            background-color: #0056b3;
        }

        @media (max-width: 768px) {
            .container {
                width: 90%;
            }

            .logo img {
                width: 80px;
                height: 80px;
            }

            .search-box input[type="text"],
            .search-box button {
                width: 90%;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="logo">
            <img src="img/pag.png" alt="Logo">
        </div>
        <div class="message">
            <i class="fas fa-info-circle"></i>
            Digite seu MAC para Renovar seu Acesso!
        </div>
        <div class="search-box">
            <form action="search_results.php" method="GET" target="_blank">
                <input type="text" id="mac" name="query" placeholder="Digite seu MAC..." required maxlength="17">
                <button type="submit" id="generateLink"><i class="fas fa-database"></i> Gerar Link</button>
            </form>
        </div>
    </div>

    <script>
        // Formatação automática para adicionar ":" após cada dois caracteres
        document.getElementById("mac").addEventListener("input", function () {
            // Remove todos os ":" para evitar conflitos ao editar
            let value = this.value.replace(/:/g, "").toUpperCase();

            // Adiciona ":" a cada dois caracteres
            let formattedValue = value.match(/.{1,2}/g)?.join(":") || value;

            // Atualiza o valor do campo
            this.value = formattedValue;

            // Limita o comprimento máximo para 17 caracteres (6 pares de 2 + 5 ":")
            if (this.value.length > 17) {
                this.value = this.value.slice(0, 17);
            }

            // Verifica se o valor formatado tem 17 caracteres para submeter o formulário
            if (this.value.length === 17) {
                document.getElementById("generateLink").click(); // Clique automático no botão
            }
        });

        // Focar automaticamente no campo de texto ao carregar a página
        window.onload = function () {
            document.getElementById("mac").focus();
        };
    </script>
</body>
</html>
