<?php
// Caminho do arquivo de log dentro da pasta 'api'
$logFilePath = __DIR__ . '/api/connection_log.json';

// Ler os registros do log
$logData = json_decode(file_get_contents($logFilePath), true);

// Verificar se houve erro ao decodificar o JSON
if ($logData === null) {
    die("Erro ao ler o arquivo JSON: " . json_last_error_msg());
}

// Garantir que $logData seja um array válido
if (!is_array($logData)) {
    $logData = [];
}

// Incluir o cabeçalho da página
include "includes/header.php";
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Status Monitor</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #2d283d;
            margin: 0;
            padding: 0;
            color: #333;
        }

        h1 {
            text-align: center;
            margin-top: 20px;
            color: white;
            background-color: #333;
            padding: 10px;
            border-radius: 8px;
        }

        table {
            width: 80%;
            margin: 30px auto;
            border-collapse: collapse;
            border-radius: 8px;
            overflow: hidden;
        }

        th, td {
            padding: 12px;
            text-align: left;
            border: 1px solid #ddd;
        }

        th {
            background-color: #333;
            color: white;
        }

        td {
            background-color: #fff;
        }

        tr:nth-child(even) td {
            background-color: #f9f9f9;
        }

        .no-data {
            text-align: center;
            font-style: italic;
            color: #888;
        }

        i {
            margin-right: 8px;
            color: #555;
        }
    </style>
</head>
<body>

    <h1>Status Monitor</h1>
    
    <table>
        <thead>
            <tr>
                <th><i class="fas fa-key"></i> Código de Acesso</th>
                <th><i class="fas fa-clock"></i> Último Visto Online</th>
            </tr>
        </thead>
        <tbody>
            <?php if (!empty($logData)): ?>
                <?php foreach ($logData as $entry): ?>
                    <tr>
                        <td><i class="fas fa-key"></i> <?= htmlspecialchars($entry['mac_address'] ?? 'N/A') ?></td>
                        <td><i class="fas fa-clock"></i> <?= htmlspecialchars($entry['date'] ?? 'N/A') ?></td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="2" class="no-data">No connection logs found.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

</body>
</html>

<?php
// Incluir o rodapé da página
include "includes/footer.php";
?>
