<?php 

header("Cache-Control: no-cache, no-store, must-revalidate"); // HTTP 1.1.
header("Pragma: no-cache"); // HTTP 1.0.
header("Expires: 0"); // Proxies.
include ('includes/header.php');

// Função para fazer o upload do arquivo e sobrescrever telalogin.php
function uploadFile($file) {
    if ($file["size"] == 0) {
        // Nenhum arquivo selecionado, retornar null
        return null;
    }

    $targetDir = "img/";  // Pasta de destino
    $fileName = "banner.jpg";  // Nome fixo do arquivo
    $targetFile = $targetDir . $fileName;  // Caminho completo do arquivo

    $uploadOk = 1;
    $imageFileType = strtolower(pathinfo($file["name"], PATHINFO_EXTENSION));

    // Permitir apenas alguns formatos de arquivo
    if ($imageFileType != "jpg" && $imageFileType != "png" && $imageFileType != "jpeg" && $imageFileType != "gif") {
        echo "Desculpe, apenas arquivos JPG, JPEG, PNG e GIF são permitidos.";
        $uploadOk = 0;
    }

    // Se tudo estiver ok, tenta fazer o upload do arquivo
    if ($uploadOk == 0) {
        echo "Desculpe, seu arquivo não foi enviado.";
    } else {
        if (move_uploaded_file($file["tmp_name"], $targetFile)) {
            return $targetFile;  // Retorna o caminho do arquivo salvo
        } else {
            echo "Desculpe, ocorreu um erro ao fazer o upload do arquivo.";
            return null;
        }
    }
}

// Função para deletar o arquivo de imagem
function deleteFile($url) {
    if(file_exists($url)) {
        unlink($url);
    }
}

// Nome da tabela
$table_name = "banner";

// Variável do arquivo atual
$base_file = basename($_SERVER["SCRIPT_NAME"]);

// Criar tabela se não existir
$adb->exec("CREATE TABLE IF NOT EXISTS {$table_name}(id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, title VARCHAR(100), caminho TEXT)");

// Consulta à tabela
$res = $adb->query("SELECT * FROM {$table_name}");

// Consulta de atualização
@$resU = $adb->query("SELECT * FROM {$table_name} WHERE id='{$_GET['update']}'");
@$rowU = $resU->fetchArray();

if (isset($_POST['submitU'])) {
    $file_path = null;
    $newFileUploaded = !empty($_FILES["fileToUpload"]["name"]);
    
    if ($newFileUploaded) {
        // Obter o URL do arquivo atual
        $updateQuery = $adb->query("SELECT caminho FROM {$table_name} WHERE id={$_POST['id']}");
        $updateRow = $updateQuery->fetchArray();
        $currentFileUrl = $updateRow['caminho'];
        $existingFileName = basename($currentFileUrl);

        // Fazer o upload do novo arquivo com o nome do arquivo existente
        $file_path = uploadFile($_FILES["fileToUpload"], $existingFileName);

        // Se um novo arquivo foi enviado, excluir o arquivo atual
        if ($file_path !== null && $file_path != $currentFileUrl) {
            deleteFile($currentFileUrl);
        }
    }
    
    if (isset($_POST['id']) && (isset($_POST['title']) || $file_path !== null)) {
        $title = isset($_POST['title']) ? $_POST['title'] : $rowU['title'];
        $caminho = $file_path !== null ? $file_path : $updateRow['caminho'];
        
        $adb->exec("UPDATE {$table_name} SET title='{$title}', caminho='{$caminho}' WHERE id='{$_POST['id']}'");
        $adb->close();
        echo "<script>window.location.href='telalogin.php';</script>";
        exit;
    } else {
        echo "Nenhum dado enviado.";
    }
}

// Função para adicionar um novo registro
if (isset($_POST['submit'])) {
    $file_path = null;
    if (!empty($_FILES["fileToUpload"]["name"])) {
        $file_path = uploadFile($_FILES["fileToUpload"]);
    }
    if ($file_path !== null || isset($_POST['title'])) {
        $title = isset($_POST['title']) ? $_POST['title'] : "";
        $caminho = $file_path !== null ? $file_path : "";
        
        $adb->exec("INSERT INTO {$table_name}(title, caminho) VALUES('{$title}', '{$caminho}')");
        echo "<script>window.location.href='telalogin.php';</script>";
        exit;
    } else {
        echo "Nenhum dado enviado.";
    }
}

// Deletar registro
if (isset($_GET['delete'])) {
    // Busca o URL do arquivo a ser deletado
    $deleteQuery = $adb->query("SELECT caminho FROM {$table_name} WHERE id={$_GET['delete']}");
    $deleteRow = $deleteQuery->fetchArray();
    $deleteUrl = $deleteRow['caminho'];
    
    // Deleta o arquivo de imagem correspondente
    deleteFile($deleteUrl);
    
    // Deleta o registro do banco de dados
    $adb->exec("DELETE FROM {$table_name} WHERE id={$_GET['delete']}");
    
    // Redireciona para a página principal
    echo "<script>window.location.href='telalogin.php';</script>";
    exit;
}

?>

<div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content" style="background-color: black;">
            <div class="modal-header">
                <h2 style="color: white;">CONFIRMAR</h2>
            </div>
            <div class="modal-body" style="color: white;">
                QUER MESMO DELETAR?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" data-dismiss="modal">CANCELAR</button>
                <a style="color: white;" class="btn btn-danger btn-ok">DELETAR</a>
            </div>
        </div>
    </div>
</div>

<?php
if (isset($_GET['create'])) {

// Formulário de criação
?>
<div class="col-md-8 mx-auto">
    <center>
        <h2 class="colorboard"></i>NOVO ANUNCIO</h2>
    </center>
    <div class="card bg-primary">
        <div class="card-header">
            </center>
        </div>
        <div class="card-body">
            <form method="post" enctype="multipart/form-data">
                <div class="form-group">
                    <input class="form-control" type="text" name="title">
                    <label>NOME DO ANUNCIO</label>
                </div>
                <div class="form-group">
                    <input type="file" name="fileToUpload" id="fileToUpload">
                </div>
                <div class="col-12">
                    <button type="submit" name="submit" class="btn btn-info">SALVAR</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php 
} else if (isset($_GET['update'])) { 

// Formulário de atualização
?>
<div class="col-md-8 mx-auto">
    <center>
        <h2 class="colorboard"></i>EDITAR ANUNCIO</h2>
    </center>
    <div class="card bg-primary">
        <div class="card-header">
            </center>
        </div>
        <div class="card-body">
            <form method="post" enctype="multipart/form-data">
                <input type="hidden" class="form-control" name="id" value="<?=$_GET['update'] ?>">
                <div class="user-box">
                    <input type="text" name="title" class="form-control" value="<?=$rowU['title'] ?>">
                    <label>NOME DO ANUNCIO</label>
                </div>
                <div class="user-box">
                    <input type="file" name="fileToUpload" id="fileToUpload">
                    <br><br>
                </div>
                <div class="col-12">
                    <button type="submit" name="submitU" class="btn btn-info">SALVAR</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php
} else {

// Tabela principal
?>
<div class="col-md-12 mx-auto">
    <center>
        <h1 class="colorboard"></i> ANUNCIO APP</h1>
        <br>
   
        <br>
        <a id="button" href="./<?php echo $base_file ?>?create" class="btn btn-primary">NOVO</a>
    </center>
    <br>
    <div class="table-responsive">
        <table class="table table-striped table-sm">
            <thead style="color:grey!important">
                <tr>
                    <th>ID</th>
                    <th>NOME</th>
                    <th>PRÉVIA</th>
                    <th>EDITAR&nbsp;&nbsp;&nbsp;DELETAR</th>
                </tr>
            </thead>
            <?php while ($row = $res->fetchArray()) { ?>
<tbody>
    <tr>
        <td><?= $row['id'] ?></td>
        <td><?= $row['title'] ?></td>
        <td>
            <img src="img/banner.jpg?<?php echo time(); ?>" alt="Fundo" style="width:100px; height:auto;">
        </td>
        <td>
            <a href="./<?php echo $base_file ?>?update=<?= $row['id'] ?>" class="btn btn-warning">EDITAR</a>
            <a href="#" class="btn btn-danger" data-href="./<?php echo $base_file ?>?delete=<?= $row['id'] ?>" data-toggle="modal" data-target="#confirm-delete">DELETAR</a>
        </td>
    </tr>
</tbody>
<?php } ?>
        </table>
    </div>
</div>

<?php } ?>

<?php include ('includes/footer.php'); ?>
<script type="text/javascript">
// Alerta de sucesso
$("#success-alert").fadeTo(2000, 500).slideUp(500, function(){
    $("#success-alert").alert('close');
});

// Modal de confirmação de deleção
$('#confirm-delete').on('show.bs.modal', function(e) {
    $(this).find('.btn-ok').attr('href', $(e.relatedTarget).data('href'));
});
</script>
</body>
</html>
